<?php
/*
 * Plugin Name: WOPshop Top Rating Products
 * Plugin URI: http://www.wop-agentur.de/wopshop/
 * Description: Top Rating Products widget for WOPshop
 * Version: 1.0.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.de
 *
 * Open Source License, GNU GPL
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WOPSHOP_PLUGIN_DIR')){
    return false;   
}

if (class_exists('Wopshop')){
    add_action('widgets_init', function(){
        register_widget('wshopTopRatingProductsWidget');
    });
}

class wshopTopRatingProductsWidget extends WP_Widget {
    public function __construct() {
        $config = Factory::getConfig();
        $lang = $config->getLang();
		
        if (is_file(__DIR__.'/lang/'.$lang.'.php')) {
            require_once(__DIR__.'/lang/'.$lang.'.php');
        } else {
            require_once(__DIR__.'/lang/en-GB.php');        
		}
		
        parent::__construct("wshop_topratingproducts", _WSHOP_TOPRATING_WIDGET, array("description" => _WSHOP_TOPRATING_DESCRIPTION));
    }

    public function widget($args, $instance) {
		Factory::loadCssFiles();
		Factory::loadLanguageFile();		
		$config = Factory::getConfig();

		$product = Factory::getTable('product');
		$cat_str = isset($instance['category_id']) ?  $instance['category_id']  : NULL;
		$count_products = isset($instance['count_products']) ? esc_attr($instance['count_products']) : '5';

		if (is_array($cat_str)) {    
			$cat_arr = array();
			foreach($cat_str as $key=>$curr){
			   if (intval($curr)) $cat_arr[$key] = intval($curr);
			}  
		} else {
			$cat_arr = array();
			if (intval($cat_str)) $cat_arr[] = intval($cat_str);
		}

		$rows = $product->getTopRatingProducts($count_products, $cat_arr);   
		addLinkToProducts($rows, 0, 1);

		$enable_addon = isset($instance['enable_addon']) ? $instance['enable_addon'] : 0;
		if ($enable_addon){
            do_action_ref_array('onBeforeDisplayProductList', array(&$rows));

			$view = new stdClass();
			$view->rows = $rows;
            do_action_ref_array('onBeforeDisplayProductListView', array(&$view));            
			$rows = $view->rows;
		}

		$noimage = $config->image_product_live_path."/noimage.gif";
		$shippinginfo = Route::_($config->shippinginfourl,1);

		$show_image     = isset($instance['show_image']) ? $instance['show_image'] : 1;
		$show_image_label     = isset($instance['show_image_label']) ? $instance['show_image_label'] : 0;
		$allow_review     = isset($instance['allow_review']) ? $instance['allow_review'] : 0;
		$short_description     = isset($instance['short_description']) ? $instance['short_description'] : 0;
		$manufacturer_name     = isset($instance['manufacturer_name']) ? $instance['manufacturer_name'] : 0;
		$product_quantity     = isset($instance['product_quantity']) ? $instance['product_quantity'] : 0;
		$product_old_price     = isset($instance['product_old_price']) ? $instance['product_old_price'] : 0;
		$product_price_default     = isset($instance['product_price_default']) ? $instance['product_price_default'] : 0;
		$display_price     = isset($instance['display_price']) ? $instance['display_price'] : 1;
		$show_tax_product     = isset($instance['show_tax_product']) ? $instance['show_tax_product'] : 0;
		$show_plus_shipping_in_product     = isset($instance['show_plus_shipping_in_product']) ? $instance['show_plus_shipping_in_product'] : 0;
		$basic_price_info     = isset($instance['basic_price_info']) ? $instance['basic_price_info'] : 0;
		$product_weight     = isset($instance['product_weight']) ? $instance['product_weight'] : 0;
		$delivery_time     = isset($instance['delivery_time']) ? $instance['delivery_time'] : 0;
		$extra_field     = isset($instance['extra_field']) ? $instance['extra_field'] : 0;
		$product_list_qty_stock     = isset($instance['product_list_qty_stock']) ? $instance['product_list_qty_stock'] : 0;
		$show_button     = isset($instance['show_button']) ? $instance['show_button'] : 1;
		$show_button_buy     = isset($instance['show_button_buy']) ? $instance['show_button_buy'] : 0;
		$show_button_detal     = isset($instance['show_button_detal']) ? $instance['show_button_detal'] : 1;
			
		
        $title = apply_filters('widget_title', $instance['title']);
        echo $args['before_widget'];
        if (! empty($title))
            echo $args['before_title'] . $title . $args['after_title'];
        ?>
<div class="topraiting_products  wshop">
<?php foreach($rows as $product){ ?>
	 <div class="block_item">
<?php 	if ($show_image && $product->image){// option modul  show_image ?>
		<div class="image">
			<div class="image_block">
<?php 		print $product->_tmp_var_image_block;?>
<?php 		if($product->label_id && $show_image_label){?>		
				<div class="product_label">
<?php 			if($product->_label_image){?>
					<img src="<?php print $product->_label_image?>" alt="<?php print htmlspecialchars($product->_label_name)?>" />
<?php			}else{?>
					<span class="label_name"><?php print $product->_label_name;?></span>
<?php			}?>						 
				</div>
<?php 		}?>
				<a href="<?php print $product->product_link?>">
					<img class="jshop_img" src="<?php print $product->image ? $product->image : $noimage;?>" alt="<?php print htmlspecialchars($product->name);?>" />
				</a>
			</div>
		</div>
<?php 	} ?>

<?php	if($allow_review){	// option modul allow_review ?>
		<table class="review_mark"><tr><td><?php print showMarkStar($product->average_rating);?></td></tr></table>
		<div class="count_commentar">
<?php 		print sprintf(_WOP_SHOP_X_COMENTAR, $product->reviews_count);?>
		</div>
<?php 	} ?>

<?php 	print $product->_tmp_var_bottom_foto;?>
		
		<div class="name">
            <a href="<?php print $product->product_link?>"><?php print $product->name?></a>
            <?php if ($config->product_list_show_product_code){?><span class="jshop_code_prod">(<?php print _WOP_SHOP_EAN?>: <span><?php print $product->product_ean;?></span>)</span><?php }?>
        </div>
		
<?php	if($short_description){	// option modul short_description ?>		
		 <div class="description">
            <?php print $product->short_description?>
        </div>
<?php 	} ?>

<?php 	if ($product->manufacturer->name && $manufacturer_name){// option modul manufacturer_name ?>
        <div class="manufacturer_name"><?php print _WOP_SHOP_MANUFACTURER;?>: <span><?php print $product->manufacturer->name?></span></div>
<?php 	}?>

<?php 	if ($product->product_quantity <=0 && !$config->hide_text_product_not_available && $product_quantity){// option modul product_quantity?>
		<div class="not_available"><?php print _WOP_SHOP_PRODUCT_NOT_AVAILABLE;?></div>
<?php 	}?>

<?php	if($product_old_price){?>
<?php 		if ($product->product_old_price > 0){// option modul product_old_price?>
		<div class="old_price"><?php if ($config->product_list_show_price_description) print _WOP_SHOP_OLD_PRICE.": ";?><span><?php print formatprice($product->product_old_price)?></span></div>
<?php 		}?>
<?php 	print $product->_tmp_var_bottom_old_price;?>
<?php 	}?>

<?php 	if ($product->product_price_default > 0 && $config->product_list_show_price_default && $product_price_default){ // option modul product_price_default?>
        <div class="default_price"><?php print _WOP_SHOP_DEFAULT_PRICE.": ";?><span><?php print formatprice($product->product_price_default)?></span></div>
<?php 	}?>

<?php	if($display_price){?>
<?php 		if ($product->_display_price){// option modul display_price?>
		<div class = "jshop_price">
<?php 		if ($config->product_list_show_price_description) print _WOP_SHOP_PRICE.": ";?>
<?php 		if ($product->show_price_from) print _WOP_SHOP_FROM." ";?>
			<span><?php print formatprice($product->product_price);?></span>
		</div>
<?php 		}?>
<?php 	print $product->_tmp_var_bottom_price;?>
<?php 	}?>

<?php 	if ($config->show_tax_in_product && $product->tax > 0 && $show_tax_product){// option modul show_tax_product?>
		<span class="taxinfo"><?php print productTaxInfo($product->tax);?></span>
<?php 	}?>

<?php 	if ($config->show_plus_shipping_in_product && $show_plus_shipping_in_product){?>
        <span class="plusshippinginfo"><?php print sprintf(_WOP_SHOP_PLUS_SHIPPING, $shippinginfo);?></span>
<?php 	}?>

<?php 	if ($product->basic_price_info['price_show'] && $basic_price_info){// option modul basic_price_info?>
		<div class="base_price"><?php print _WOP_SHOP_BASIC_PRICE?>: <?php if ($product->show_price_from) print _WOP_SHOP_FROM;?> <span><?php print formatprice($product->basic_price_info['basic_price'])?> / <?php print $product->basic_price_info['name'];?></span></div>
<?php 	}?>

<?php 	if ($config->product_list_show_weight && $product->product_weight > 0 && $product_weight){// option modul product_weight?>
        <div class="productweight"><?php print _WOP_SHOP_WEIGHT?>: <span><?php print formatweight($product->product_weight)?></span></div>
<?php 	}?>

<?php 	if ($product->delivery_time != '' && $delivery_time){// option modul delivery_time?>
            <div class="deliverytime"><?php print _WOP_SHOP_DELIVERY_TIME?>: <span><?php print $product->delivery_time?></span></div>
<?php 	}?>

<?php 	if (is_array($product->extra_field) && $extra_field){// option modul extra_field?>
		<div class="extra_fields">
<?php 		foreach($product->extra_field as $extra_field){?>
			<div><?php print $extra_field['name'];?>: <?php print $extra_field['value']; ?></div>
<?php 		}?>
		</div>
<?php	}?>


<?php 	if ($config->product_list_show_qty_stock && $product_list_qty_stock){// option modul product_list_qty_stock?>
            <div class="qty_in_stock"><?php print _WOP_SHOP_QTY_IN_STOCK?>: <span><?php print sprintQtyInStock($product->qty_in_stock)?></span></div>
<?php 	}?>

<?php	if($show_button){?>
<?php 	print $product->_tmp_var_top_buttons;?>

        <div class="buttons">
<?php 		if ($product->buy_link && $show_button_buy){?>
            <a class="button_buy" href="<?php print $product->buy_link?>"><?php print _WOP_SHOP_BUY?></a> &nbsp;
<?php 		}?>
<?php 		if ($show_button_detal){?>
            <a class="button_detail" href="<?php print $product->product_link?>"><?php print _WOP_SHOP_DETAIL?></a>
<?php		}?>
<?php 		print $product->_tmp_var_buttons;?>
        </div>
		
<?php 	print $product->_tmp_var_bottom_buttons;?>
<?php	}?>
	</div>	
	
<?php print $product->_tmp_var_end?>

<?php } ?>
</div>
        <?php echo $args['after_widget'];
    }
    
    public function form($instance) {
        Factory::loadLanguageFile(null, 1);
        
        $title     = isset($instance['title']) ? esc_attr($instance['title']) : ''; 
		$count_products     = isset($instance['count_products']) ? esc_attr($instance['count_products']) : '5';
		$category_id     = isset($instance['category_id']) ?  $instance['category_id']  : '';
		$cats = $this->getCategories();
		$enable_addon     = isset($instance['enable_addon']) ? $instance['enable_addon']  : 1;
		$show_image     = isset($instance['show_image']) ? $instance['show_image'] : 1;
		$show_image_label     = isset($instance['show_image_label']) ? $instance['show_image_label'] : 0;
		$allow_review     = isset($instance['allow_review']) ? $instance['allow_review'] : 0;
		$short_description     = isset($instance['short_description']) ? $instance['short_description'] : 0;
		$manufacturer_name     = isset($instance['manufacturer_name']) ? $instance['manufacturer_name'] : 0;
		$product_quantity     = isset($instance['product_quantity']) ? $instance['product_quantity'] : 0;
		$product_old_price     = isset($instance['product_old_price']) ? $instance['product_old_price'] : 0;
		$product_price_default     = isset($instance['product_price_default']) ? $instance['product_price_default'] : 0;
		$display_price     = isset($instance['display_price']) ? $instance['display_price'] : 1;
		$show_tax_product     = isset($instance['show_tax_product']) ? $instance['show_tax_product'] : 0;
		$show_plus_shipping_in_product     = isset($instance['show_plus_shipping_in_product']) ? $instance['show_plus_shipping_in_product'] : 0;
		$basic_price_info     = isset($instance['basic_price_info']) ? $instance['basic_price_info'] : 0;
		$product_weight     = isset($instance['product_weight']) ? $instance['product_weight'] : 0;
		$delivery_time     = isset($instance['delivery_time']) ? $instance['delivery_time'] : 0;
		$extra_field     = isset($instance['extra_field']) ? $instance['extra_field'] : 0;
		$product_list_qty_stock     = isset($instance['product_list_qty_stock']) ? $instance['product_list_qty_stock'] : 0;
		$show_button     = isset($instance['show_button']) ? $instance['show_button'] : 1;
		$show_button_buy     = isset($instance['show_button_buy']) ? $instance['show_button_buy'] : 0;
		$show_button_detal     = isset($instance['show_button_detal']) ? $instance['show_button_detal'] : 1;		
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>
        <p><label for="<?php echo $this->get_field_id('count_products'); ?>"><?php echo _WSHOP_TOPRAITING_PRODUCT_QUANTITY; ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('count_products'); ?>" name="<?php echo $this->get_field_name('count_products'); ?>" type="text" value="<?php echo $count_products; ?>" /></p>
        <p><label for="<?php echo $this->get_field_id('category_id'); ?>"><?php echo _WOP_SHOP_CATEGORIES; ?></label> 
            <?php echo HTML::_('select.genericlist', $cats, 'category_id[]', 'multiple="multiple" size="10"','category_id', 'name', $category_id);?></p> 		
        <p><?php echo _WSHOP_TOPRAITING_ENABLE_ADDON; ?>
			<?php echo HTML::_('select.booleanlist', 'enable_addon', 'class = "btn btn-default" size = "1"', $enable_addon, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>  
        <p><?php echo _WSHOP_TOPRAITING_SHOW_IMAGE; ?>
			<?php echo HTML::_('select.booleanlist', 'show_image', 'class = "btn btn-default" size = "1"', $show_image, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p> 
        <p><?php echo _WSHOP_TOPRAITING_SHOW_IMAGES_LABEL; ?>
			<?php echo HTML::_('select.booleanlist', 'show_image_label', 'class = "btn btn-default" size = "1"', $show_image_label, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p> 		
        <p><?php echo _WSHOP_TOPRAITING_ALLOW_REVIEW; ?>
			<?php echo HTML::_('select.booleanlist', 'allow_review', 'class = "btn btn-default" size = "1"', $allow_review, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p> 
        <p><?php echo _WSHOP_TOPRAITING_SHORT_DESCRIPTION; ?>
			<?php echo HTML::_('select.booleanlist', 'short_description', 'class = "btn btn-default" size = "1"', $short_description, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p> 		
        <p><?php echo _WSHOP_TOPRAITING_MANUFACTURER_NAME; ?>
			<?php echo HTML::_('select.booleanlist', 'manufacturer_name', 'class = "btn btn-default" size = "1"', $manufacturer_name, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>	
        <p><?php echo _WSHOP_TOPRAITING_PRODUCT_QUANTITY; ?>
			<?php echo HTML::_('select.booleanlist', 'product_quantity', 'class = "btn btn-default" size = "1"', $product_quantity, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>	
        <p><?php echo _WSHOP_TOPRAITING_PRODUCT_OLD_PRICE; ?>
			<?php echo HTML::_('select.booleanlist', 'product_old_price', 'class = "btn btn-default" size = "1"', $product_old_price, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_PRODUCT_PRICE_DEFAULT; ?>
			<?php echo HTML::_('select.booleanlist', 'product_price_default', 'class = "btn btn-default" size = "1"', $product_price_default, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_DISPLAY_PRICE; ?>
			<?php echo HTML::_('select.booleanlist', 'display_price', 'class = "btn btn-default" size = "1"', $display_price, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_SHOW_TAX_PRODUCT; ?>
			<?php echo HTML::_('select.booleanlist', 'show_tax_product', 'class = "btn btn-default" size = "1"', $show_tax_product, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_SHOW_PLUS_SHIPING_PRODUCT; ?>
			<?php echo HTML::_('select.booleanlist', 'show_plus_shipping_in_product', 'class = "btn btn-default" size = "1"', $show_plus_shipping_in_product, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_BASIC_PRICE_INFO; ?>
			<?php echo HTML::_('select.booleanlist', 'basic_price_info', 'class = "btn btn-default" size = "1"', $basic_price_info, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>		
        <p><?php echo _WSHOP_TOPRAITING_PRODUCT_WEIGHT; ?>
			<?php echo HTML::_('select.booleanlist', 'product_weight', 'class = "btn btn-default" size = "1"', $product_weight, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_DELIVERY_TIME; ?>
			<?php echo HTML::_('select.booleanlist', 'delivery_time', 'class = "btn btn-default" size = "1"', $delivery_time, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_EXTRA_FIELD; ?>
			<?php echo HTML::_('select.booleanlist', 'extra_field', 'class = "btn btn-default" size = "1"', $extra_field, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_PRODUCT_LIST_QTY_STOCK; ?>
			<?php echo HTML::_('select.booleanlist', 'product_list_qty_stock', 'class = "btn btn-default" size = "1"', $product_list_qty_stock, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_SHOW_BUTTON; ?>
			<?php echo HTML::_('select.booleanlist', 'show_button', 'class = "btn btn-default" size = "1"', $show_button, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_SHOW_BUTTON_BUY; ?>
			<?php echo HTML::_('select.booleanlist', 'show_button_buy', 'class = "btn btn-default" size = "1"', $show_button_buy, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>
        <p><?php echo _WSHOP_TOPRAITING_SHOW_BUTTON_DETAL; ?>
			<?php echo HTML::_('select.booleanlist', 'show_button_detal', 'class = "btn btn-default" size = "1"', $show_button_detal, _WOP_SHOP_YES, _WOP_SHOP_NO);?></p>		
    <?php 
    }
	
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $new_instance = wp_parse_args((array) $new_instance, array('title' => ''));
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['count_products'] = strip_tags($new_instance['count_products']);
		$instance['category_id'] = Request::getVar('category_id');
		$instance['show_image'] = Request::getInt('show_image');
		$instance['show_image_label'] = Request::getInt('show_image_label');
		$instance['allow_review'] = Request::getInt('allow_review');
		$instance['short_description'] = Request::getInt('short_description');
		$instance['manufacturer_name'] = Request::getInt('manufacturer_name');
		$instance['product_quantity'] = Request::getInt('product_quantity');
		$instance['product_old_price'] = Request::getInt('product_old_price');
		$instance['product_price_default'] = Request::getInt('product_price_default');
		$instance['display_price'] = Request::getInt('display_price');
		$instance['show_tax_product'] = Request::getInt('show_tax_product');
		$instance['show_plus_shipping_in_product'] = Request::getInt('show_plus_shipping_in_product');
		$instance['show_image'] = Request::getInt('show_image');
		$instance['basic_price_info'] = Request::getInt('basic_price_info');		
		$instance['product_weight'] = Request::getInt('product_weight');
		$instance['delivery_time'] = Request::getInt('delivery_time');		
		$instance['extra_field'] = Request::getInt('extra_field');
		$instance['product_list_qty_stock'] = Request::getInt('product_list_qty_stock');
		$instance['show_button'] = Request::getInt('show_button');
		$instance['show_button_buy'] = Request::getInt('show_button_buy');
		$instance['show_button_detal'] = Request::getInt('show_button_detal');		
        return $instance;        
    }

    private function getCategories(){
        $tmp = new stdClass();
        $tmp->category_id = "";
        $tmp->name = _WOP_SHOP_ALL;  
        $categories_1  = array($tmp);

        return array_merge($categories_1 , buildTreeCategory(0));
    }
}
