<?php
/*
 * Plugin Name: WOPshop Search Widget
 * Plugin URI: http://www.wop-agentur.com/wopshop/
 * Description: Search widget for WOPshop
 * Version: 1.0.1
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.com
 *
 * Open Source License, GNU GPL
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WOPSHOP_PLUGIN_DIR')){
    return false;   
}

if (class_exists('Wopshop')){
    add_action('widgets_init', function(){
        register_widget('wshopSearchWidget');
    });
}

class wshopSearchWidget extends WP_Widget {
    public function __construct() {
        $config = Factory::getConfig();
        $lang = $config->getLang();

        if (is_file(__DIR__.'/lang/'.$lang.'.php')){
            require_once(__DIR__.'/lang/'.$lang.'.php');
        } else {
            require_once(__DIR__.'/lang/en-GB.php');
        }
        
        parent::__construct('wshop_wshopsearch', _WSHOP_SEARCH_WIDGET, array("description" => _WSHOP_SEARCH_DESCRIPTION));     
    }

    public function widget($args, $instance) {
        Factory::loadLanguageFile();
        $title = apply_filters( 'widget_title', $instance['title'] );
        $category_id = $instance['category_id'];
        $search_type   = $instance['search_type'];
        $advanced_search = $instance['advanced_search'];
        if ($advanced_search) {
            $adv_search_link = SEFLink('controller=search', 1);
        }
        $search = Request::getVar('search',''); 
        echo $args['before_widget']; 
        if ( ! empty( $title ) ) echo $args['before_title'] . $title . $args['after_title'];?>
        <script type = "text/javascript">
        function isEmptyValue(value){
            var pattern = /\S/;
            return ret = (pattern.test(value)) ? (true) : (false);
        }
        </script>
        <form name = "searchForm" method = "post" action="<?php print SEFLink("controller=search&task=result", 1);?>" onsubmit = "return isEmptyValue(jQuery('#wshop_search').val())">
        <input type="hidden" name="setsearchdata" value="1">
        <input type = "hidden" name = "category_id" value = "<?php print $category_id?>" />
        <input type = "hidden" name = "search_type" value = "<?php print $search_type;?>" />
        <input type = "text" class = "inputbox" style = "width: 110px" name = "search" id = "wshop_search" value = "<?php print $search?>" />
        <input class = "button" type = "submit" value = "<?php print _WOP_SHOP_GO?>" />
        <?php if ($advanced_search) {?>
        <br /><a href = "<?php print $adv_search_link?>"><?php print _WOP_SHOP_ADVANCED_SEARCH?></a>
        <?php } ?>
        </form>
        <?php echo $args['after_widget'];
    }
    
    public function form($instance) {
        Factory::loadLanguageFile(null, 1);
        
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
        
        if (isset($instance['category_id'])) {
            $category_id = $instance['category_id'];
        }
        
        if (isset($instance['search_type'])) {
            $search_type = $instance['search_type'];
        }
        
        if (isset($instance['advanced_search'])) {
            $advanced_search = $instance['advanced_search'];
        }
        
        $cats = $this->getCategories();
        
        $_search_type = array();
        $_search_type[] = HTML::_('select.option', 'any', _WOP_SHOP_ANY_WORDS, 'search_type_id', 'search_type_value');
        $_search_type[] = HTML::_('select.option', 'all', _WOP_SHOP_ALL_WORDS, 'search_type_id', 'search_type_value');
        $_search_type[] = HTML::_('select.option', 'exact', _WOP_SHOP_EXACT_WORDS, 'search_type_id', 'search_type_value');
        $_advanced_search = array();
        $_advanced_search[] = HTML::_('select.option', '0', _WOP_SHOP_NO, 'advanced_search_id', 'advanced_search_value');
        $_advanced_search[] = HTML::_('select.option', '1', _WOP_SHOP_YES, 'advanced_search_id', 'advanced_search_value');        
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php echo _WOP_SHOP_TITLE; ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'category_id' ); ?>"><?php echo _WOP_SHOP_CATEGORIES; ?></label>
            <?php echo HTML::_('select.genericlist', $cats, 'category_id', 'class = "inputbox" size = "1"', 'category_id', 'name', (int)$category_id);?>
        </p>        
        <p>
            <label for="<?php echo $this->get_field_id( 'sort' ); ?>"><?php echo _WOP_SHOP_SEARCH_FOR; ?></label>
            <?php echo HTML::_('select.genericlist', $_search_type, 'search_type', 'class = "inputbox" size = "1"', 'search_type_id', 'search_type_value', esc_attr($search_type));?>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'show_image' ); ?>"><?php echo _WOP_SHOP_ADVANCED_SEARCH; ?></label>
            <?php echo HTML::_('select.genericlist', $_advanced_search, 'advanced_search', 'class = "inputbox" size = "1"', 'advanced_search_id', 'advanced_search_value', (int)$advanced_search);?>
        </p>
    <?php }
    
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';        
        $search_type = Request::getString('search_type');
        $instance['search_type'] = (!empty($search_type)) ? strip_tags($search_type) : 'any';        
        $category_id = Request::getInt('category_id');
        $instance['category_id'] = (!empty($category_id)) ? (int)$category_id : 0;
        $advanced_search = Request::getInt('advanced_search');
        $instance['advanced_search'] = (!empty($advanced_search)) ? (int)$advanced_search : 0;
        
        return $instance;
    }
    
    private function getCategories(){
        $tmp = new stdClass();
        $tmp->category_id = "";
        $tmp->name = _WOP_SHOP_ALL;  
        $firstCategory = array($tmp);

        return array_merge($firstCategory , buildTreeCategory(0));
    }
}