<?php
/*
 * Plugin Name: WOPshop Recent Comments
 * Plugin URI: http://www.wop-agentur.de/wopshop/
 * Description: Recent comments widget for WOPshop
 * Version: 1.0.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.de
 *
 * Open Source License, GNU GPL
 */
 
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WOPSHOP_PLUGIN_DIR')){
    return false;   
}

if (class_exists('Wopshop')){
    add_action('widgets_init', function(){
        register_widget('wshopRecentCommentsWidget');
    });
}

class wshopRecentCommentsWidget extends WP_Widget {
    public function __construct() {      
        $config = Factory::getConfig();
        $lang = $config->getLang();

        if (is_file(__DIR__.'/lang/'.$lang.'.php')) {
            require_once(__DIR__.'/lang/'.$lang.'.php');
        } else {
            require_once(__DIR__.'/lang/en-GB.php');        
		}
		
        parent::__construct("wshoprecentcomments", _WSHOP_RC_WIDGET, array("description" => _WSHOP_RC_DESCRIPTION));     
    }

    public function widget($args, $instance) {?>
        <?php
			global $wpdb;
            $title = apply_filters('widget_title', $instance['title']);
			$count_comments  = isset($instance['count_comments']) ?  $instance['count_comments'] : 10;

            echo $args['before_widget']; 
			if (!empty($title)){
				echo $args['before_title'] . $title . $args['after_title'];
            }
            
            Factory::loadCssFiles();
            Factory::loadLanguageFile();
			$wshopConfig = Factory::getConfig();
 
			$query = "SELECT rev.user_name, rev.time, rev.review, rev.mark, pr.`name_".$wshopConfig->cur_lang."` as pr_name, cat.`name_".$wshopConfig->cur_lang."` as cat_name, pr.product_id as pr_id, pr_cat.category_id as cat_id
			FROM `".$wpdb->prefix."wshop_products` AS pr
			INNER JOIN `".$wpdb->prefix."wshop_products_reviews` AS rev
			INNER JOIN `".$wpdb->prefix."wshop_products_to_categories` AS pr_cat ON pr_cat.product_id = pr.product_id
			LEFT JOIN `".$wpdb->prefix."wshop_categories` AS cat ON pr_cat.category_id = cat.category_id
			WHERE pr.product_id = rev.product_id and rev.publish = 1 and pr.product_publish = '1' AND cat.category_publish='1'
			GROUP BY rev.review_id
			ORDER BY rev.review_id desc LIMIT ".$count_comments;
			$review = $wpdb->get_results($query);

			$max_mark = $wshopConfig->max_mark;
			if ($max_mark % 2) $max_mark -= 1;
			$wid = 8 * $max_mark;

			foreach ($review as $key => $value){
				?>
				<div class="review_item"> 
					<?php
						$pr_id = $value->pr_id;
						$url = Route::_("controller=product&task=view&product_id=$pr_id",1);
						echo $value->cat_name." >> <a href='$url'>".$value->pr_name."</a><br>";

						echo "<b>".$value->user_name."</b>, ".date("d.m.Y", strtotime($value->time))."<br>";

						echo $value->review."<br>";

						if ($value->mark > 0){
							$mark = $value->mark;
							$wid_a = $wid * $mark / $max_mark;
							echo "<div class='review_mark'><div class='stars_no_active' style='width:".$wid."px'><div class='stars_active' style='width:".$wid_a."px'></div></div></div>";
						}
					?>
				 </div> 
			<?php
			}
			echo $args['after_widget']; ?>
        <?php
    }
    
    public function form($instance) {
        if (isset($instance[ 'title' ])) {
            $title = $instance[ 'title' ];
        }
		$count_comments     = isset($instance['count_comments']) ? esc_attr($instance['count_comments']) : '10';		     
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo _WSHOP_RC_TITLE; ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('count_comments'); ?>"><?php echo _WSHOP_RC_COUNT; ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('count_comments'); ?>" name="<?php echo $this->get_field_name('count_comments'); ?>" type="text" value="<?php echo esc_attr($count_comments); ?>" />
        </p>        
	
    <?php }
    
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (! empty($new_instance['title'])) ? strip_tags($new_instance['title']) : ''; 
		$instance['count_comments'] = (! empty($new_instance['count_comments'])) ? strip_tags($new_instance['count_comments']) : '';
        return $instance;
    }
}