<?php
/*
 * Plugin Name: WOPshop Manufacturers
 * Plugin URI: http://www.wop-agentur.de/wopshop/
 * Description: Manufacturers widget for WOPshop
 * Version: 1.0.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.de
 *
 * Open Source License, GNU GPL
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WOPSHOP_PLUGIN_DIR')){
    return false;   
}

if (class_exists('Wopshop')){
    add_action('widgets_init', function(){
        register_widget('wshopManufacturersWidget');
    });
}

class wshopManufacturersWidget extends WP_Widget {
    public function __construct() {
        $config = Factory::getConfig();
        $lang = $config->getLang();

        if (is_file(__DIR__.'/lang/'.$lang.'.php')) {
            require_once(__DIR__.'/lang/'.$lang.'.php');
        } else {
            require_once(__DIR__.'/lang/en-GB.php');	
		}
		
        parent::__construct('wshop_manufacturers', _WSHOP_MANUFACTURER_MANUFACTURER, array("description" => _WSHOP_MANUFACTURER_DESCRIPTION));     
    }

    public function widget($args, $instance) {
        $title      = apply_filters('widget_title', $instance['title']);
        $field_sort = $instance['sort'];
        $ordering   = $instance['ordering'];
        $show_image = $instance['show_image'];
        $config = Factory::getConfig();
        $manufacturer_id = Request::getInt('manufacturer_id');

        $manufacturer = Factory::getTable('manufacturer');
        $list = $manufacturer->getAllManufacturers(1, $field_sort, $ordering);
        foreach ($list as $key => $value){
            $list[$key]->link = Route::_('controller=manufacturer&task=view&manufacturer_id='.$list[$key]->manufacturer_id);
        }
        echo $args['before_widget']; 
        if (! empty($title)) echo $args['before_title'] . $title . $args['after_title'];?>
        <div class="manufactuter_list">
        <?php
          foreach($list as $curr){
              $class = "jshop_menu_level_0";
                  if ($curr->manufacturer_id == $manufacturer_id) $class = $class."_a";      
              ?>
              <div class = "<?php print $class?>">
                    <a href = "<?php print $curr->link?>"><?php print $curr->name?>
                        <?php if ($show_image && $curr->manufacturer_logo){?>
                            <img align = "absmiddle" src = "<?php print $config->image_manufs_live_path."/".$curr->manufacturer_logo?>" alt = "<?php print $curr->name?>" />
                        <?php } ?>
                    </a>
              </div>
        <?php } ?>
        </div>
        <?php echo $args['after_widget']; ?>
    <?php
    }
    
    public function form($instance) {
        if (isset($instance[ 'title' ])) {
            $title = $instance[ 'title' ];
        }
        if (isset($instance[ 'sort' ])) {
            $sort = $instance[ 'sort' ];
        }
        if (isset($instance[ 'ordering' ])) {
            $ordering = $instance[ 'ordering' ];
        }
        if (isset($instance[ 'show_image' ])) {
            $show_image = $instance[ 'show_image' ];
        }
        $_sort = array();
        $_sort[] = HTML::_('select.option', 'id', _WSHOP_MANUFACTURER_ID, 'sort_id', 'sort_value');
        $_sort[] = HTML::_('select.option', 'name', _WSHOP_MANUFACTURER_NAME, 'sort_id', 'sort_value');
        $_sort[] = HTML::_('select.option', 'order', _WSHOP_MANUFACTURER_ORDERING, 'sort_id', 'sort_value');
        $_ordering = array();
        $_ordering[] = HTML::_('select.option', 'asc', _WSHOP_MANUFACTURER_ASCENDING, 'ordering_id', 'ordering_value');
        $_ordering[] = HTML::_('select.option', 'desc', _WSHOP_MANUFACTURER_DESCENDING, 'ordering_id', 'ordering_value');
        $_show_image = array();
        $_show_image[] = HTML::_('select.option', '0', _WOP_SHOP_NO, 'show_image_id', 'show_image_value');
        $_show_image[] = HTML::_('select.option', '1', _WOP_SHOP_YES, 'show_image_id', 'show_image_value');        
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo _WSHOP_MANUFACTURER_TITLE; ?></label> 
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('sort'); ?>"><?php echo _WSHOP_MANUFACTURER_SORT; ?></label>
            <?php echo HTML::_('select.genericlist', $_sort, 'sort', 'class = "inputbox" size = "1"','sort_id', 'sort_value', esc_attr($sort));?>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('ordering'); ?>"><?php echo _WSHOP_MANUFACTURER_ORDERING; ?></label> 
            <?php echo HTML::_('select.genericlist', $_ordering, 'ordering', 'class = "inputbox" size = "1"','ordering_id', 'ordering_value', esc_attr($ordering));?>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('show_image'); ?>"><?php echo _WSHOP_MANUFACTURER_SHOW_IMAGE; ?></label> 
            <?php echo HTML::_('select.genericlist', $_show_image, 'show_image', 'class = "inputbox" size = "1"','show_image_id', 'show_image_value', esc_attr($show_image));?>
        </p>
	
    <?php }
    
    public function update($new_instance, $old_instance) {
        $instance = array();
        $sort = Request::getString('sort');
        $ordering = Request::getString('ordering');
        $show_image = Request::getString('show_image');
        $instance['title'] = (! empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['sort'] = (! empty($sort)) ? strip_tags($sort) : 'id';
        $instance['ordering'] = (!empty($ordering)) ? strip_tags($ordering) : 'asc';
        $instance['show_image'] = (!empty($show_image)) ? htmlentities($show_image) : '0';
        return $instance;
    }
}