<?php
/*
 * Plugin Name: WOPshop Currencies
 * Plugin URI: http://www.wop-agentur.de/wopshop/
 * Description: Currency widget for WOPshop
 * Version: 1.0.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.de
 *
 * Open Source License, GNU GPL
 */
 
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WOPSHOP_PLUGIN_DIR')){
    return false;   
}

if (class_exists('Wopshop')){
    add_action('widgets_init', function(){
        register_widget('wshopCurrencyWidget');
    });
}

class wshopCurrencyWidget extends WP_Widget {
    public function __construct() {
        $config = Factory::getConfig();
        $lang = $config->getLang();
		
        if (is_file(__DIR__.'/lang/'.$lang.'.php')){
            require_once(__DIR__.'/lang/'.$lang.'.php');
        } else {
            require_once(__DIR__.'/lang/en-GB.php');        
		}
		
        parent::__construct('wshop_currencies', _WSHOP_CURRENCIES, array("description" => _WSHOP_CURRENCIES_DESCRIPTION));     
    }

    public function widget($args, $instance) {
        $currency = Factory::getTable('currency');
        $currencis_list = $currency->getAllCurrencies(1);
        $config = Factory::getConfig();   
        $config->loadCurrencyValue(); 
        $currencies_display_list = HTML::_('select.genericlist',$currencis_list,'id_currency','class = "inputbox" size = "1" onchange = "this.form.submit()"' ,'currency_id','currency_name',$config->cur_currency);
        $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);

        echo $args['before_widget'];
        if (!empty($title)) echo $args['before_title'] . $title . $args['after_title'];?>
        <form id="currency_select" name="currency_select" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
        <?php echo $currencies_display_list;?>
        </form>
        <?php 
        echo $args['after_widget'];            
    }
    
    public function form($instance) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>
    <?php }
    
    public function update($new_instance, $old_instance) {
        $instance['title'] = strip_tags($new_instance['title']);
        return $instance;
    }
}