<?php
/*
 * Plugin Name: WPshopping Search Widget
 * Plugin URI: http://www.wop-agentur.com/wopshop/
 * Description: Search widget for WPshopping
 * Version: 1.6.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.com
 *
 * Open Source License, GNU GPL
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WPSHOPPING_PLUGIN_DIR')){
    return false;   
}

if (class_exists('WPshopping')){
    add_action('widgets_init', function(){
        register_widget('WPshoppingSearchWidget');
    });
}

class WPshoppingSearchWidget extends WP_Widget {
    
    protected $template_path = 'wpshopping_wshopsearch';
    
    public function __construct() {
        $this->loadLanguage();
        $widget_ops = array(
            'description'                 => WPshoppingText::_('WPSHOPPING_SEARCH_DESCRIPTION'),
            'customize_selective_refresh' => true,
            'show_instance_in_rest'       => true,
        );
        
        parent::__construct('wpshopping_wshopsearch', WPshoppingText::_('WPSHOPPING_SEARCH_WIDGET'), $widget_ops);
    }

    public function widget($args, $instance) {
        $instance = wp_parse_args( (array) $instance, self::get_defaults() );
        extract($instance);
        if ($advanced_search) {
            $adv_search_link = WPshoppingHelper::SEFLink('controller=search', 1);
        }
        
		$template = locate_template(
			array(
				trailingslashit( $this->template_path ) . 'default.php',
			)
		);
        if(!$template){
            $template = __DIR__ .'/tmpl/default.php';
        }
        include $template;
    }
    
    public function form($instance) {
        $init = count($instance)? false : true;
        $instance = wp_parse_args( (array) $instance, self::get_defaults() );
        if($init){
           $instance['search_type'] = 'any';
        }
        extract($instance);
        
		$cats = WPshoppingHelper::buildTreeCategory(0);
               
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php echo WPshoppingText::_('WPSHOPPING_TITLE'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
		<p>
            <label for="<?php echo $this->get_field_id( 'category_id' ); ?>"><?php echo WPshoppingText::_('WPSHOPPING_CATEGORY'); ?></label>
            <select name="<?php echo esc_attr( $this->get_field_name( 'category_id' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'category_id' ) ); ?>" class="widefat"  size="1">
                <option value="" <?php echo $category_id == ''? 'selected="selected"' : ''?>><?php echo WPshoppingText::_('WPSHOPPING_ALL'); ?></option>
                <?php foreach ($cats as $cat) { ?>
                <option value="<?php echo $cat->category_id?>" <?php echo $cat->category_id == $category_id? 'selected="selected"' : ''?>><?php echo $cat->name; ?></option>
                <?php } ?>
				
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'search_type' ) ); ?>"><?php echo WPshoppingText::_('WPSHOPPING_SEARCH_FOR'); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'search_type' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'search_type' ) ); ?>" class="widefat">
				<option value="any"<?php selected( $search_type , 'any' ); ?>><?php echo WPshoppingText::_('WPSHOPPING_ANY_WORDS'); ?></option>
				<option value="all"<?php selected( $search_type , 'all' ); ?>><?php echo WPshoppingText::_('WPSHOPPING_ALL_WORDS'); ?></option>
				<option value="exact"<?php selected( $search_type , 'exact' ); ?>><?php echo WPshoppingText::_('WPSHOPPING_EXACT_WORDS'); ?></option>
			</select>
		</p>
        
        <?php
        echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_ADVANCED_SEARCH'), 'advanced_search',  $advanced_search);
        
    }
    
    public function update( $new_instance, $old_instance ) {
		$instance     = $old_instance;
		$new_instance = wp_parse_args( (array) $new_instance, self::get_defaults() );
        
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['search_type'] = (!empty($new_instance['search_type'])) ? strip_tags($new_instance['search_type']) : 'any';
        $instance['category_id'] = $new_instance['category_id'];
        $instance['advanced_search'] = isset( $new_instance['advanced_search'] ) ? (bool) $new_instance['advanced_search'] : false;
        return $instance;

    }

    private function loadLanguage(){
        WPshoppingFactory::initLanguageFile();
        $config = WPshoppingFactory::getConfig();
        $lang = $config->getLang();
        if (is_file(__DIR__.'/lang/'.$lang.'.ini')){
            WPshoppingText::load(__DIR__.'/lang/'.$lang.'.ini');
        } else {
            WPshoppingText::load(__DIR__.'/lang/en-GB.ini');
        }
    }
    
	private static function get_defaults() {
		return array(
			'title' => '',
			'search_type' => '',
			'category_id' => '',
			'advanced_search' => false,
		);
	}
    
	private function checkboxInput($label, $name, $val) {
		$field = '<p><input class="checkbox" type="checkbox" '.checked( $val, true, false ).' id="'. $this->get_field_id( $name ) .'" name="'.  $this->get_field_name( $name ) .'" /><label for="'. $this->get_field_id( $name ) .'">'. $label.'</label></p>';
        return $field;
	}
}