<?php
/*
 * Plugin Name: WPshopping Recent Comments
 * Plugin URI: http://www.wop-agentur.de/wopshop/
 * Description: Recent comments widget for WPshopping
 * Version: 1.6.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.de
 *
 * Open Source License, GNU GPL
 */
 
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WPSHOPPING_PLUGIN_DIR')){
    return false;   
}

if (class_exists('WPshopping')){
    add_action('widgets_init', function(){
        register_widget('WPshoppingRecentCommentsWidget');
    });
}

class WPshoppingRecentCommentsWidget extends WP_Widget {
    protected $template_path = 'wpshopping_recentcomments';
    
    public function __construct() {
        $this->loadLanguage();
        $widget_ops = array(
            'description'                 => WPshoppingText::_('WPSHOPPING_RC_DESCRIPTION'),
            'customize_selective_refresh' => true,
            'show_instance_in_rest'       => true,
        );


        parent::__construct("wpshopping_recentcomments", WPshoppingText::_('WPSHOPPING_RC_WIDGET'), $widget_ops);
    }

    public function widget($args, $instance) {
        global $wpdb;
        $title = apply_filters('widget_title', $instance['title']);
        $count_comments  = isset($instance['count_comments']) ?  $instance['count_comments'] : 10;
        $wpshoppingConfig = WPshoppingFactory::getConfig();

        $query = "SELECT rev.user_name, rev.time, rev.review, rev.mark, pr.`name_".$wpshoppingConfig->cur_lang."` as pr_name, cat.`name_".$wpshoppingConfig->cur_lang."` as cat_name, pr.product_id as pr_id, pr_cat.category_id as cat_id
        FROM `".$wpdb->prefix."wshop_products` AS pr
        INNER JOIN `".$wpdb->prefix."wshop_products_reviews` AS rev
        INNER JOIN `".$wpdb->prefix."wshop_products_to_categories` AS pr_cat ON pr_cat.product_id = pr.product_id
        LEFT JOIN `".$wpdb->prefix."wshop_categories` AS cat ON pr_cat.category_id = cat.category_id
        WHERE pr.product_id = rev.product_id and rev.publish = 1 and pr.product_publish = '1' AND cat.category_publish='1'
        GROUP BY rev.review_id
        ORDER BY rev.review_id desc LIMIT ".$count_comments;
        $review = $wpdb->get_results($query);

        $max_mark = $wpshoppingConfig->max_mark;
        if ($max_mark % 2) $max_mark -= 1;
        $wid = 8 * $max_mark;
            
		$template = locate_template(
			array(
				trailingslashit( $this->template_path ) . 'default.php',
			)
		);
        if(!$template){
            $template = __DIR__ .'/tmpl/default.php';
        }
        include $template;

    }
    
    public function form($instance) {
        $title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $count_comments    = isset( $instance['count_comments'] ) ? absint( $instance['count_comments'] ) : 10;     
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo WPshoppingText::_('WPSHOPPING_RC_TITLE'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('count_comments'); ?>"><?php echo WPshoppingText::_('WPSHOPPING_RC_COUNT'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('count_comments'); ?>" name="<?php echo $this->get_field_name('count_comments'); ?>" type="text" value="<?php echo esc_attr($count_comments); ?>" />
        </p>        
	
    <?php }
    
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (! empty($new_instance['title'])) ? strip_tags($new_instance['title']) : ''; 
		$instance['count_comments'] = (! empty($new_instance['count_comments'])) ? strip_tags($new_instance['count_comments']) : 10;
        return $instance;
    }

    private function loadLanguage(){
        WPshoppingFactory::initLanguageFile();
        $config = WPshoppingFactory::getConfig();
        $lang = $config->getLang();
        if (is_file(__DIR__.'/lang/'.$lang.'.ini')){
            WPshoppingText::load(__DIR__.'/lang/'.$lang.'.ini');
        } else {
            WPshoppingText::load(__DIR__.'/lang/en-GB.ini');
        }
    }
}