<?php
/*
 * Plugin Name: WPshopping Manufacturers
 * Plugin URI: http://www.wop-agentur.de/wopshop/
 * Description: Manufacturers widget for WPshopping
 * Version: 1.6.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.de
 *
 * Open Source License, GNU GPL
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WPSHOPPING_PLUGIN_DIR')){
    return false;   
}

if (class_exists('WPshopping')){
    add_action('widgets_init', function(){
        register_widget('WPshoppingManufacturersWidget');
    });
}

class WPshoppingManufacturersWidget extends WP_Widget {
    protected $template_path = 'wpshopping_manufacturers';
    
    public function __construct() {
        $this->loadLanguage();
        $widget_ops = array(
            'description'                 => WPshoppingText::_('WPSHOPPING_MANUFACTURER_DESCRIPTION'),
            'customize_selective_refresh' => true,
            'show_instance_in_rest'       => true,
        );


        parent::__construct('wpshopping_manufacturers', WPshoppingText::_('WPSHOPPING_MANUFACTURER_MANUFACTURER'), $widget_ops);
    }

    public function widget($args, $instance) {
        $instance = wp_parse_args( (array) $instance, self::get_defaults() );
        extract($instance);
        $category_id = WPshoppingRequest::getInt('category_id');
        $config = WPshoppingFactory::getConfig();
        
        $manufacturer_id = WPshoppingRequest::getInt('manufacturer_id');

        $manufacturer = WPshoppingFactory::getTable('manufacturer');
        $list = $manufacturer->getAllManufacturers(1, $sort, $ordering);
        foreach ($list as $key => $value){
            $list[$key]->link = WPshoppingHelper::SEFLink('controller=manufacturer&task=view&manufacturer_id='.$list[$key]->manufacturer_id);
        }
        
		$template = locate_template(
			array(
				trailingslashit( $this->template_path ) . 'default.php',
			)
		);
        if(!$template){
            $template = __DIR__ .'/tmpl/default.php';
        }
        include $template;
    }
    
    public function form($instance) {
        $instance = wp_parse_args( (array) $instance, self::get_defaults() );
        extract($instance);     
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php echo WPshoppingText::_('WPSHOPPING_MANUFACTURER_TITLE'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'sort' ) ); ?>"><?php echo WPshoppingText::_('WPSHOPPING_MANUFACTURER_SORT'); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'sort' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'sort' ) ); ?>" class="widefat">
				<option value="id"<?php selected( $sort , 'id' ); ?>><?php echo WPshoppingText::_('WPSHOPPING_MANUFACTURER_ID'); ?></option>
				<option value="name"<?php selected( $sort , 'name' ); ?>><?php echo WPshoppingText::_('WPSHOPPING_MANUFACTURER_NAME'); ?></option>
				<option value="order"<?php selected( $sort , 'ordering' ); ?>><?php echo WPshoppingText::_('WPSHOPPING_MANUFACTURER_ORDERING'); ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'ordering' ) ); ?>"><?php echo WPshoppingText::_('WPSHOPPING_MANUFACTURER_ORDERING'); ?></label>
			<select name="<?php echo esc_attr( $this->get_field_name( 'ordering' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'ordering' ) ); ?>" class="widefat">
				<option value="asc"<?php selected( $ordering , 'asc' ); ?>><?php echo WPshoppingText::_('WPSHOPPING_MANUFACTURER_ASCENDING'); ?></option>
				<option value="desc"<?php selected( $ordering , 'desc' ); ?>><?php echo WPshoppingText::_('WPSHOPPING_MANUFACTURER_DESCENDING'); ?></option>
			</select>
		</p>
    <?php 
    echo $this->checkboxInput(WPshoppingText::_('WPSHOPPING_MANUFACTURER_SHOW_IMAGE'), 'show_image',  $show_image);
        }
    
    public function update($new_instance, $old_instance) {
		$instance     = $old_instance;
		$new_instance = wp_parse_args( (array) $new_instance, self::get_defaults() );
        
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['sort'] = isset( $new_instance['sort'] ) ? $new_instance['sort'] : 'order';
        $instance['ordering'] = isset( $new_instance['ordering'] ) ? $new_instance['ordering'] : 'asc';
        $instance['show_image'] = isset( $new_instance['show_image'] ) ? (bool) $new_instance['show_image'] : false;
        return $instance;
    }
    
	private static function get_defaults() {
		$defaults = array(
			'title' => '',
			'sort' => 'order',
			'ordering' => 'asc',
			'show_image' => false,
		);
		return apply_filters( 'WPshoppingManufacturersWidget', $defaults );
	}
    
	private function checkboxInput($label, $name, $val) {
		$field = '<p><input class="checkbox" type="checkbox" '.checked( $val, true, false ).' id="'. $this->get_field_id( $name ) .'" name="'.  $this->get_field_name( $name ) .'" /><label for="'. $this->get_field_id( $name ) .'">'. $label.'</label></p>';
        return $field;
	}

    private function loadLanguage(){
        WPshoppingFactory::initLanguageFile();
        $config = WPshoppingFactory::getConfig();
        $lang = $config->getLang();
        if (is_file(__DIR__.'/lang/'.$lang.'.ini')){
            WPshoppingText::load(__DIR__.'/lang/'.$lang.'.ini');
        } else {
            WPshoppingText::load(__DIR__.'/lang/en-GB.ini');
        }
    }
}