<?php
/*
 * Plugin Name: WPshopping Label Products
 * Plugin URI: http://www.wop-agentur.de/wopshop/
 * Description: Label Products widget for WPshopping
 * Version: 1.6.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.de
 *
 * Open Source License, GNU GPL
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WPSHOPPING_PLUGIN_DIR')){
    return false;   
}

if (class_exists('WPshopping')){
	add_action('widgets_init', function(){
		register_widget('WPshoppingLabelProductsWidget');
	});
}

class WPshoppingLabelProductsWidget extends WP_Widget {
    
    protected $template_path = 'wpshopping_labelproducts';
    
    public function __construct() {
        $this->loadLanguage();
        $widget_ops = array(
            'description'                 => WPshoppingText::_('WPSHOPPING_LABEL_DESCRIPTION'),
            'customize_selective_refresh' => true,
            'show_instance_in_rest'       => true,
        );

        parent::__construct("wpshopping_labelproducts", WPshoppingText::_('WPSHOPPING_LABEL_WIDGET'), $widget_ops);
    }

    public function widget($args, $instance) {
		WPshoppingFactory::loadCssFiles();
		$config = WPshoppingFactory::getConfig();

		$product = WPshoppingFactory::getTable('product');
        
        $instance = wp_parse_args( (array) $instance, self::get_defaults() );
        extract($instance);
        
        if(!is_array($category_id)){
            $category_id = [];
        }
        $cat_arr = array();
        foreach($category_id as $key=>$curr){
           if (intval($curr)){
               $cat_arr[] = intval($curr);
           } 
        }

		$rows = $product->getProductLabel($label_id, $count_products, $cat_arr);

		WPshoppingHelper::addLinkToProducts($rows, 0, 1);
        
		if ($enable_addon){
            do_action_ref_array('onBeforeDisplayProductList', array(&$rows));

			$view = new stdClass();
			$view->rows = $rows;
            do_action_ref_array('onBeforeDisplayProductListView', array(&$view));            
			$rows = $view->rows;
		}

		$noimage = $config->image_product_live_path."/noimage.gif";
		$shippinginfo = WPshoppingHelper::SEFLink($config->shippinginfourl,1);
        
		$template = locate_template(
			array(
				trailingslashit( $this->template_path ) . 'default.php',
			)
		);
        if(!$template){
            $template = __DIR__ .'/tmpl/default.php';
        }
        include $template;
    }
    
    public function form($instance) {
        $init = count($instance)? false : true;
        $instance = wp_parse_args( (array) $instance, self::get_defaults() );
        if($init){
           $instance['enable_addon'] = true; 
           $instance['show_image'] = true; 
           $instance['display_price'] = true; 
           $instance['show_button'] = true; 
           $instance['show_button_detal'] = true; 
        }
        extract($instance);
        if(!is_array($category_id)){
            $category_id = [];
        }
        $showAllCats = false;
        if(empty($category_id) || in_array('', $category_id)){
            $showAllCats = true;
        }
		$cats = WPshoppingHelper::buildTreeCategory(0);

        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id( 'count_products' ); ?>"><?php echo WPshoppingText::_('WPSHOPPING_LABEL_COUNT_OF_PRODUCTS'); ?></label>
            <input class="tiny-text" id="<?php echo $this->get_field_id( 'count_products' ); ?>" name="<?php echo $this->get_field_name( 'count_products' ); ?>" type="number" step="1" min="1" value="<?php echo $count_products; ?>" size="3" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id( 'label_id' ); ?>"><?php echo WPshoppingText::_('WPSHOPPING_LABEL_LABEL_ID'); ?></label>
            <input class="tiny-text" id="<?php echo $this->get_field_id( 'label_id' ); ?>" name="<?php echo $this->get_field_name( 'label_id' ); ?>" type="number" step="1" min="1" value="<?php echo $label_id; ?>" size="3" />
        </p>
        
		<p>
            <label for="<?php echo $this->get_field_id( 'category_id' ); ?>"><?php echo WPshoppingText::_('WPSHOPPING_LABEL_CATEGORIES'); ?></label>
            <select name="<?php echo esc_attr( $this->get_field_name( 'category_id' ) ); ?>[]" id="<?php echo esc_attr( $this->get_field_id( 'category_id' ) ); ?>" class="widefat" multiple="multiple" size="10">
                <option value="" <?php echo $showAllCats? 'selected="selected"' : ''?>><?php echo WPshoppingText::_('WPSHOPPING_ALL'); ?></option>
                <?php foreach ($cats as $cat) { ?>
                <option value="<?php echo $cat->category_id?>" <?php echo in_array($cat->category_id, $category_id)? 'selected="selected"' : ''?>><?php echo $cat->name; ?></option>
                <?php } ?>
				
			</select>
		</p>
        
        <?php
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_ENABLE_ADDON'), 'enable_addon',  $enable_addon);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_SHOW_IMAGE'), 'show_image',  $show_image);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_SHOW_IMAGES_LABEL'), 'show_image_label',  $show_image_label);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_ALLOW_REVIEW'), 'allow_review',  $allow_review);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_SHORT_DESCRIPTION'), 'short_description',  $short_description);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_MANUFACTURER_NAME'), 'manufacturer_name',  $manufacturer_name);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_QUANTITY'), 'product_quantity',  $product_quantity);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_OLD_PRICE'), 'product_old_price',  $product_old_price);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_PRICE_DEFAULT'), 'product_price_default',  $product_price_default);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_DISPLAY_PRICE'), 'display_price',  $display_price);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_SHOW_TAX_PRODUCT'), 'show_tax_product',  $show_tax_product);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_SHOW_PLUS_SHIPING_PRODUCT'), 'show_plus_shipping_in_product',  $show_plus_shipping_in_product);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_BASIC_PRICE_INFO'), 'basic_price_info',  $basic_price_info);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_WEIGHT'), 'product_weight',  $product_weight);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_DELIVERY_TIME'), 'delivery_time',  $delivery_time);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_EXTRA_FIELD'), 'extra_field',  $extra_field);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_LIST_QTY_STOCK'), 'product_list_qty_stock',  $product_list_qty_stock);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_SHOW_BUTTON'), 'show_button',  $show_button);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_SHOW_BUTTON_BUY'), 'show_button_buy',  $show_button_buy);
            echo self::checkboxInput(WPshoppingText::_('WPSHOPPING_LABEL_PRODUCT_SHOW_BUTTON_DETAL'), 'show_button_detal',  $show_button_detal);
    }
	
    public function update($new_instance, $old_instance) {
        
		$instance     = $old_instance;
		$new_instance = wp_parse_args( (array) $new_instance, self::get_defaults() );

		$instance['title'] = strip_tags( $new_instance['title'] );
        $instance['enable_addon'] = isset( $new_instance['enable_addon'] ) ? (bool) $new_instance['enable_addon'] : false;
        $instance['show_image'] = isset( $new_instance['show_image'] ) ? (bool) $new_instance['show_image'] : false;
        $instance['show_image_label'] = isset( $new_instance['show_image_label'] ) ? (bool) $new_instance['show_image_label'] : false;
        $instance['allow_review'] = isset( $new_instance['allow_review'] ) ? (bool) $new_instance['allow_review'] : false;
        $instance['short_description'] = isset( $new_instance['short_description'] ) ? (bool) $new_instance['short_description'] : false;
        $instance['manufacturer_name'] = isset( $new_instance['manufacturer_name'] ) ? (bool) $new_instance['manufacturer_name'] : false;
        $instance['product_quantity'] = isset( $new_instance['product_quantity'] ) ? (bool) $new_instance['product_quantity'] : false;
        $instance['product_old_price'] = isset( $new_instance['product_old_price'] ) ? (bool) $new_instance['product_old_price'] : false;
        $instance['product_price_default'] = isset( $new_instance['product_price_default'] ) ? (bool) $new_instance['product_price_default'] : false;
        $instance['display_price'] = isset( $new_instance['display_price'] ) ? (bool) $new_instance['display_price'] : false;
        $instance['show_tax_product'] = isset( $new_instance['show_tax_product'] ) ? (bool) $new_instance['show_tax_product'] : false;
        $instance['show_plus_shipping_in_product'] = isset( $new_instance['show_plus_shipping_in_product'] ) ? (bool) $new_instance['show_plus_shipping_in_product'] : false;
        $instance['basic_price_info'] = isset( $new_instance['basic_price_info'] ) ? (bool) $new_instance['basic_price_info'] : false;
        $instance['product_weight'] = isset( $new_instance['product_weight'] ) ? (bool) $new_instance['product_weight'] : false;
        $instance['delivery_time'] = isset( $new_instance['delivery_time'] ) ? (bool) $new_instance['delivery_time'] : false;
        $instance['extra_field'] = isset( $new_instance['extra_field'] ) ? (bool) $new_instance['extra_field'] : false;
        $instance['product_list_qty_stock'] = isset( $new_instance['product_list_qty_stock'] ) ? (bool) $new_instance['product_list_qty_stock'] : false;
        $instance['show_button'] = isset( $new_instance['show_button'] ) ? (bool) $new_instance['show_button'] : false;
        $instance['show_button_buy'] = isset( $new_instance['show_button_buy'] ) ? (bool) $new_instance['show_button_buy'] : false;
        $instance['show_button_detal'] = isset( $new_instance['show_button_detal'] ) ? (bool) $new_instance['show_button_detal'] : false;
        
		$instance['category_id'] = $new_instance['category_id'];
		$instance['count_products'] = (int)$new_instance['count_products'];
		$instance['label_id'] = (int)$new_instance['label_id'];
		
        return $instance;        
    }
    
//    private function getCategories(){
//        $tmp = new stdClass();
//        $tmp->category_id = "";
//        $tmp->name = WPSHOPPING_ALL;  
//        $categories_1  = array($tmp);
//
//        return array_merge($categories_1 , WPshoppingHelper::buildTreeCategory(0));
//    }
    
	private static function get_defaults() {
		$defaults = array(
			'title' => '',
            'category_id' => '',
			'count_products' => 5,
			'label_id' => 1,
			'enable_addon' => false,
			'show_image' => false,
			'show_image_label' => false,
			'allow_review' => false,
			'short_description' => false,
			'manufacturer_name' => false,
			'product_quantity' => false,
			'product_old_price' => false,
			'product_price_default' => false,
			'display_price' => false,
			'show_tax_product' => false,
			'show_plus_shipping_in_product' => false,
			'basic_price_info' => false,
			'product_weight' => false,
			'delivery_time' => false,
			'delivery_time' => false,
			'extra_field' => false,
			'product_list_qty_stock' => false,
			'show_button' => false,
			'show_button_buy' => false,
			'show_button_detal' => false,
			'category_id' => [],
		);
		return apply_filters( 'wpshopping_labelproducts', $defaults );
	}

	private function checkboxInput($label, $name, $val) {
		$field = '<p><input class="checkbox" type="checkbox" '.checked( $val, true, false ).' id="'. $this->get_field_id( $name ) .'" name="'.  $this->get_field_name( $name ) .'" /><label for="'. $this->get_field_id( $name ) .'">'. $label.'</label></p>';
        return $field;
	}

    private function loadLanguage(){
        WPshoppingFactory::initLanguageFile();
        $config = WPshoppingFactory::getConfig();
        $lang = $config->getLang();
        if (is_file(__DIR__.'/lang/'.$lang.'.ini')){
            WPshoppingText::load(__DIR__.'/lang/'.$lang.'.ini');
        } else {
            WPshoppingText::load(__DIR__.'/lang/en-GB.ini');
        }
    }
}