<?php
/*
 * Plugin Name: WPshopping Currencies
 * Plugin URI: http://www.wop-agentur.de/wopshop/
 * Description: Currency widget for WPshopping
 * Version: 1.6.0
 * Author: MAXXmarketing GmbH
 * Author URI: http://www.wop-agentur.de
 *
 * Open Source License, GNU GPL
 */
 
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!defined('WPSHOPPING_PLUGIN_DIR')){
    return false;   
}

if (class_exists('WPshopping')){
    add_action('widgets_init', function(){
        register_widget('WPshoppingCurrencyWidget');
    });
}

class WPshoppingCurrencyWidget extends WP_Widget {
    
    protected $template_path = 'wpshopping_currencies';
    
    public function __construct() {
        $this->loadLanguage();
        $widget_ops = array(
            'description'                 => WPshoppingText::_('WPSHOPPING_WIDGET_CURRENCIES_DESCRIPTION'),
            'customize_selective_refresh' => true,
            'show_instance_in_rest'       => true,
        );


        parent::__construct('wpshopping_currencies', WPshoppingText::_('WPSHOPPING_WIDGET_CURRENCIES'), $widget_ops);
    }

    public function widget($args, $instance) {
        $instance = wp_parse_args( (array) $instance, self::get_defaults() );
        extract($instance);
        $currency = WPshoppingFactory::getTable('currency');
        $currencis_list = $currency->getAllCurrencies(1);
        $config = WPshoppingFactory::getConfig();
        $config->loadCurrencyValue();
        $currencies_display_list = WPshoppingHTML::_('select.genericlist',$currencis_list,'id_currency','class = "inputbox" size = "1" onchange = "this.form.submit()"' ,'currency_id','currency_name',$config->cur_currency);
		$template = locate_template(
			array(
				trailingslashit( $this->template_path ) . 'default.php',
			)
		);
        if(!$template){
            $template = __DIR__ .'/tmpl/default.php';
        }
        include $template;          
    }
    
    public function form($instance) {
        $instance = wp_parse_args( (array) $instance, self::get_defaults() );
        extract($instance);    
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>
    <?php }
    
    public function update($new_instance, $old_instance) {
		$instance     = $old_instance;
		$new_instance = wp_parse_args( (array) $new_instance, self::get_defaults() );     
        $instance['title'] = strip_tags($new_instance['title']);
        return $instance;
    }
    
	private static function get_defaults() {
		$defaults = array(
			'title' => '',
		);
		return apply_filters( 'wshopCurrencyWidget', $defaults );
	}

    private function loadLanguage(){
        WPshoppingFactory::initLanguageFile();
        $config = WPshoppingFactory::getConfig();
        $lang = $config->getLang();
        if (is_file(__DIR__.'/lang/'.$lang.'.ini')){
            WPshoppingText::load(__DIR__.'/lang/'.$lang.'.ini');
        } else {
            WPshoppingText::load(__DIR__.'/lang/en-GB.ini');
        }
    }
}